#!/bin/bash
#
# Скрипт обновляет хранилище рабочего среза SVN OpenSCADA
# Должен запускаться, например, в каталоге svn_oscada,
# где рабочий срез лежит в каталоге OpenSCADA
# By RY, 18.07.14
#

SVN_REPO="svn://oscada.org/trunk/OpenSCADA"
SVN_DIR="OpenSCADA"
TMP_DIR="/var/tmp"
P_NAME="openscada-" # Необходимо для ebuild
A_NAME=".tar.gz"
C_DIR=$PWD

E="echo -e"
OK='\033[01;33mГотово.'
CLI='\033[01;36m'
CLO='\033[00m'
SEP='\n----------------------------------------'

OSC_INIT="oscada_gentoo.init"

REV () # Определение версии
{
	REV=`svn info $1/ | grep Revision`
	REV=${REV:10}
}

# Current revision
REV $SVN_DIR
REV_IS=$REV

ARGS=" "
if [ $# -eq 0 ] 
then
	REV $SVN_REPO
else
	REV=$1
	ARGS=$ARGS"-r "$REV" "
fi

if [[ $REV -eq $REV_IS ]]
then
	$E "$SEP\n $CLI The specified version is the existing ($REV_IS). Nothing to do.$CLO$SEP"
	exit
else
	$E "$SEP\n $CLI Обновляем хранилище ... $CLO"
	svn co $ARGS$SVN_REPO
fi

if [[ $? = 0 ]]
	then $E $OK $CLO $SEP
	else exit $?
fi

P_NAME=$P_NAME$REV
TMP_DIR=$TMP_DIR/$P_NAME

$E "$CLI Копируем в рабочий каталог ... $CLO"
cp -R $SVN_DIR $TMP_DIR
if [[ $? = 0 ]]
	then $E $OK $CLO $SEP
	else exit $?
fi

$E "$CLI Переходим в рабочий каталог, считаем, что autoreconf не нужен ... $CLO"
cd $TMP_DIR
#autoreconf -ivf
if [[ $? = 0 ]]
	then $E $OK $CLO $SEP
	else exit $?
fi

$E "$CLI Проверряем наличие $OSC_INIT"
if [[ -f data/$OSC_INIT ]]
then
    $E "$CLI $OSC_INIT в наличии. $CLO"
else
    $E "$CLI $OSC_INIT отсутствует, копируем ../$OSC_INIT в data/$OSC_INIT $CLO"
    cp ../$OSC_INIT data/$OSC_INIT
fi
if [[ $? = 0 ]]
	then $E $OK $CLO $SEP
	else exit $?
fi

#$E $CLI Накладываем пач ... $CLO
$E "$CLI Считаем, что пач уже не нужен ... $CLO"
#patch -i ../svn.patch configure.in
#if [[ $? = 0 ]]
#	then $E $OK $CLO $SEP
#	else exit $?
#fi

A_NAME=$P_NAME$A_NAME
$E "$CLI Поднимаемся наверх и пакуем все в $A_NAME ... $CLO"
cd ..
tar --exclude=".svn*" -czf $A_NAME $P_NAME
if [[ $? = 0 ]]
	then $E $OK $CLO $SEP
	else exit $?
fi

$E "$CLI Удаляем рабочий каталог ... $CLO"
rm -rf $P_NAME
if [[ $? = 0 ]]
	then $E $OK $CLO $SEP
	else exit $?
fi

$E "$CLI Переносим архив $PWD/$A_NAME в $C_DIR ... $CLO"
mv $A_NAME $C_DIR/
cd $C_DIR
