################################################################################
#
# openscada
#
################################################################################

OPENSCADA_VERSION = 0.8.13
OPENSCADA_SOURCE = openscada-$(OPENSCADA_VERSION).tar.lzma
OPENSCADA_LICENSE = GPLv2
OPENSCADA_LICENSE_FILES = COPYING
OPENSCADA_SITE = http://oscada.org/oscadaArch/0.8.0
OPENSCADA_AUTORECONF = YES

OPENSCADA_CONF_OPTS = --disable-AllModuls

#databases
ifeq ($(BR2_PACKAGE_MYSQL),y)
OPENSCADA_DEPENDENCIES += mysql
OPENSCADA_CONF_OPTS += --enable-MySQL=incl --with-mysql=$(STAGING_DIR)/usr/bin/mysql_config
OPENSCADA_CONF_SCRIPTS += mysql_config 
endif

ifeq ($(BR2_PACKAGE_SQLITE),y)
OPENSCADA_DEPENDENCIES += sqlite
OPENSCADA_CONF_OPTS += --enable-SQLite=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DBF),y)
# OPENSCADA_DEPENDENCIES += sqlite
OPENSCADA_CONF_OPTS += --enable-DBF=incl
endif

ifeq ($(BR2_PACKAGE_POSTGRESQL),y)
OPENSCADA_DEPENDENCIES += postgresql
OPENSCADA_CONF_OPTS += --enable-PostgreSQL=incl --with-postgresql=$(STAGING_DIR)/usr/bin/pg_config
endif

ifeq ($(BR2_PACKAGE_FIREBIRD),y)
OPENSCADA_DEPENDENCIES += firebird
OPENSCADA_CONF_OPTS += --enable-FireBird=incl
endif

ifeq ($(BR2_PACKAGE_OPENSSL_BIN),y)
OPENSCADA_DEPENDENCIES += openssl
	
	ifeq ($(BR2_PACKAGE_OPENSCADA_SSL),y)
	OPENSCADA_CONF_OPTS += --enable-SSL=incl
	endif
	
	ifeq ($(BR2_PACKAGE_OPENSCADA_OPC_UA),y)
	OPENSCADA_CONF_OPTS += --enable-OPC_UA=incl
	endif
endif

#transport
ifeq ($(BR2_PACKAGE_OPENSCADA_SOCKETS),y)
OPENSCADA_CONF_OPTS += --enable-Sockets=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_SERIAL),y)
OPENSCADA_CONF_OPTS += --enable-Serial=incl
endif

#archive
ifeq ($(BR2_PACKAGE_OPENSCADA_FS_ARCHIVE),y)
OPENSCADA_CONF_OPTS += --enable-FSArch=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DB_ARCHIVE),y)
OPENSCADA_CONF_OPTS += --enable-DBArch=incl
endif

#DAQ
ifeq ($(BR2_PACKAGE_OPENSCADA_DAQ_SYSTEM),y)
OPENSCADA_CONF_OPTS += --enable-System=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_BLOCK_CALC),y)
OPENSCADA_CONF_OPTS += --enable-BlockCalc=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_JAVA_LIKE_CALC),y)
OPENSCADA_CONF_OPTS += --enable-JavaLikeCalc=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DIAMOND_BOARDS),y)
OPENSCADA_CONF_OPTS += --enable-DiamondBoards=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_LOGIC_LEV),y)
OPENSCADA_CONF_OPTS += --enable-LogicLev=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_SNMP),y)
OPENSCADA_CONF_OPTS += --enable-SNMP=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DAQ_SIEMENS),y)
OPENSCADA_CONF_OPTS += --enable-Siemens=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_MODBUS),y)
OPENSCADA_CONF_OPTS += --enable-ModBus=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DCON),y)
OPENSCADA_CONF_OPTS += --enable-DCON=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DAQ_GATE),y)
OPENSCADA_CONF_OPTS += --enable-DAQGate=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_PORTAUDIO),y)
OPENSCADA_CONF_OPTS += --enable-SoundCard=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DAQ_ICPDAS),y)
OPENSCADA_CONF_OPTS += --enable-ICP_DAS=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DAQ_AMR_DEVS),y)
OPENSCADA_CONF_OPTS += --enable-AMRDevs=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_DAQ_BFN),y)
OPENSCADA_CONF_OPTS += --enable-BFN=incl
endif

#protocol
ifeq ($(BR2_PACKAGE_OPENSCADA_HTTP),y)
OPENSCADA_CONF_OPTS += --enable-HTTP=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_SELF_SYSTEM),y)
OPENSCADA_CONF_OPTS += --enable-SelfSystem=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_USER_PROTOCOL),y)
OPENSCADA_CONF_OPTS += --enable-UserProtocol=incl
endif

#user interface
ifeq ($(BR2_PACKAGE_OPENSCADA_VCA_ENGINE),y)
OPENSCADA_CONF_OPTS += --enable-VCAEngine=incl
endif

ifeq ($(BR2_PACKAGE_OPENSCADA_WEB_VISION),y)
OPENSCADA_CONF_OPTS += --enable-WebVision=incl
endif

$(eval $(autotools-package))
# $(eval $(host-autotools-package))
