import json
import sys

# Get the number of arguments
args = len(sys.argv) - 1

# Check the number of arguments
if args == 0:
    print("Error. Expected two args")
    sys.exit(1)

if args == 1:
    if sys.argv[1] == '-h':
        print("Usage: python script.py <fileA.json> <fileB.json>")
        sys.exit(0)

if args != 2:
    print("Error. Expected two args")
    sys.exit(1)

# Open files and handle errors
try:
    with open(sys.argv[1], 'r') as fileA, open(sys.argv[2], 'r') as fileB:
        A = json.load(fileA)
        B = json.load(fileB)

    # Compare the contents
    if A == B:
        print('equal')
    else:
        print('not equal')
except FileNotFoundError as e:
    print(f"Error: {e}")
except json.JSONDecodeError:
    print("Error: One of the files is not a valid JSON.")
except Exception as e:
    print(f"An unexpected error occurred: {e}")

