#!/bin/bash
#
# Копирование ebuild и исходника, пересоздание Manifest
# 27.01.15 - RY :)
#

OK='\033[01;33mГотово.'
CLI='\033[01;36m'
CLO='\033[00m'
SEP='\n----------------------------------------'
E='echo -e'

# Определяем версию
NAME="openscada"
REV=`svn info OpenSCADA/ | grep Revision`
REV=${REV:10}
SRC=$NAME-$REV.tar.gz

EB_PATH="/usr/local/portage/dev-util/"$NAME
EB=$NAME".ebuild.050415"
EB_DEST=$EB_PATH/$NAME-$REV.ebuild
MANIF=$EB_PATH/Manifest

if [ "$UID" -ne 0 ]
then
  $E $CLI To run this script, you must have the privileges of root. $CLO
	exit
fi

$E $CLI"\n" Copy $SRC to /home/distfiles/$CLO
cp $SRC /home/distfiles/
if [[ $? = 0 ]]
	then $E $OK $CLO $SEP
	else exit $?
fi

if [ -f $MANIF ]
	then 
		$E $CLI Delete $MANIF $CLO
		rm $MANIF
	else $E $MANIF not found.
fi

$E $CLI "Delete old developed ebuilds..."$CLO
rm $EB_PATH/$NAME-[0-9][0-9][0-9][0-9]*
$E $CLI "Copy" $EB "to" $EB_DEST $CLO
cp $EB $EB_DEST

$E $CLI Create $MANIF $CLO
ebuild $EB_DEST digest
if [[ $? = 0 ]]
	then $E $OK $CLO $SEP
	else exit $?
fi
