 
//OpenSCADA system module DAQ.DCON file: DCON_client.h
/***************************************************************************
 *   Copyright (C) 2008-2011 by Almaz Karimov                              *
 *		   2008-2014 by Roman Savochenko, rom_as@oscada.org        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef OWEN_CLIENT_H
#define OWEN_CLIENT_H

#include <tcontroller.h>
#include <ttypedaq.h>
#include <tparamcontr.h>

#include <string>
#include <vector>
#include <map>

#undef _
#define _(mess) mod->I18N(mess)

#define MaxLenReq 200

using std::string;
using std::vector;
using std::map;
using namespace OSCADA;

namespace Owen
{

	struct auxData {
		union owdb {
			struct { char c[7]; };				//	|c7	|c6	|c5	|c4	|c3	|c2	|c1	|c0	|
			double d;							//	|				d				|
			struct { long int li0, li1; } ;		//	|		li1		|		li0		|
			struct { int i0, i1, i2, i3; } ;	//	|	i3	|	i2	|	i1	|	i0	|
			struct { float f0, f1; } ;			//	|		f1		|		f0		|
			long long int lli;					//	|				lli				|
		} db;
		char ftype; // f-0 || s-0, f_b-1 || s_h-1, bd-2, 
		bool mod;
		string err;
		string readReq;
		string writeData;
		string strData;
		TFld::Type type;
	};

//******************************************************
//* TMdPrm                                             *
//******************************************************
class TMdContr;

class TMdPrm : public TParamContr
{
    public:
	//Methods
	TMdPrm( string name, TTypeParam *tp_prm );
	TMdPrm();
	~TMdPrm( );

	void enable( );
	void disable( );

	TElem &elem( )		{ return p_el; }
	TMdContr &owner( );

	//Attributes
	TElem	p_el;		//Work atribute elements
	int64_t	&mod_addr;	//Module address
	char	&addr_11bit;	//8 11 bit device adress lenght mode
	ResString comm_err;
	bool end_prm;

	auxData data, data0;
	std::map<string, auxData> attr;

    protected:
	//Methods
	bool cfgChange( TCfg &co, const TVariant &pc );
	void cntrCmdProc( XMLNode *opt );	//Control interface command process

    private:
	//Methods
	void postEnable( int flag );
	void vlGet( TVal &vo );
	void vlSet( TVal &vo, const TVariant &vl, const TVariant &pvl );
	void vlArchMake( TVal &val );
};

//******************************************************
//* TMdContr                                           *
//******************************************************
class TMdContr: public TController
{
    public:
	//Methods
	TMdContr( string name_c, const string &daq_db, TElem *cfgelem);
	~TMdContr( );

	string getStatus( );

	double	period( )	{ return mPer; }
	string	cron( )		{ return cfg("SCHEDULE").getS(); }
	int	prior( )	{ return mPrior; }
	string	addr( )		{ return mAddr; }

	AutoHD<TMdPrm> at( const string &nm )	{ return TController::at(nm); }
	void prmEn( const string &id, bool val );

	unsigned hashCRC( string req, bool hash );
	string OwenReq( string &pdu );
	string attrName( string attr );
	string netName( string name, string *err );
	//bool formPDU( int addr, bool addr11bit, bool read, int dblk, int attr_code, int data, string *pdu, string *err );
	string chstr2hexspstr( string in );
	string hexspstr2chstr( string in );
	string int2chstr( int in );
	bool formPDU( int addr, bool addr11bit, bool read, int dblk, int attr_code, string data, string *pdu, string *err );
	char char4hash( char ch, char next );
	string revertStr( string in );
	float ieee2float( string data );
	float b2float( string data );
	int hashName( string name );
	string bin2ascii( string in );
	string ascii2bin( string in );
	int float2b( float val, int pr, int dblk );

    protected:
	//Methods
	void load_( );
	void disable_( );
	void start_( );
	void stop_( );
	void cntrCmdProc( XMLNode *opt );	//Control interface command process
	bool cfgChange( TCfg &co, const TVariant &pc );

    private:
	//Methods
	TParamContr *ParamAttach( const string &name, int type );
	static void *Task( void *icntr );

	//Attributes
	Res	en_res, req_res;		//Resource for enable params and request values
	TCfg	&mAddr;				//Transport device address
	//TCfg	&mAdi;				//Additional debug info
	int64_t	&mPerOld,			//Acquisition task (seconds)
			&mPrior,			//Process task priority
			&connTry;			//Connections try
	char	&mAdi;				//Additional debug info
	bool	prc_st,				//Process task active
			call_st,       		//Calc now stat
			endrun_req;			//Request to stop of the Process task
	vector< AutoHD<TMdPrm> >  p_hd;

	double	mPer, tm_gath;			//Gathering time
};

//*************************************************
//* TTpContr                                      *
//*************************************************
class TTpContr: public TTypeDAQ
{
    public:
	//Methods
	TTpContr( string name );
	~TTpContr( );

    protected:
	//Methods
	void load_( );
	void save_( );

	bool redntAllow( )	{ return true; }

    private:
	//Methods
	void postEnable( int flag );
	TController *ContrAttach( const string &name, const string &daq_db );
};

extern TTpContr *mod;

} //End namespace

#endif //OWEN_CLIENT_H
